/*jslint node: true, nomen: true, unparam: true */
/*global window, jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore',
	'applets/wound-care-applet/core/models/SkinCheckModel',
	'applets/wound-care-applet/core/models/SkinCheckPastModel',
	'applets/wound-care-applet/core/views/AppletView',
	'applets/wound-care-applet/core/views/BradenReviewView',
	'applets/wound-care-applet/core/views/BradenScaleView',
	'applets/wound-care-applet/core/views/EducationView',
	'applets/wound-care-applet/core/views/TabView',
	'applets/wound-care-applet/core/views/NewSkinInspectionView',
	'applets/wound-care-applet/core/views/PrevInspectionView',
	'applets/wound-care-applet/core/views/PrevInspectionsView',
	'applets/wound-care-applet/core/views/RiskFactorsView',
	'applets/wound-care-applet/core/models/Resources',
	'applets/wound-care-applet/core/models/AppletModel',
	'applets/wound-care-applet/core/extensions/list-generator/Controller'

],
	function (Portal, Backbone, Marionette, $, _, SkinCheckModel, SkinCheckPastModel, AppletView
		, BradenReviewView, BradenScaleView, EducationView, TabsView, NewSkinInspectionView,PrevInspectionView, PrevInspectionsView, RiskFactorsView) {
		var WoundCareApplet = {}, that, venti, history, modelUrl, educationToNote, listgenController, tabsView, lastViewEvent;
		var keys = ['sensoryPerception', 'moisture', 'activity', 'mobility', 'nutrition', 'frictionAndShear'];
				var timer;
				return Marionette.Controller.extend({
					initialize: function (options) {
						window.Portal = Portal;
						lastViewEvent='';
						that = this;
						venti =  false;
						WoundCareApplet = options.woundCareApplet|| {};

						WoundCareApplet.vent = new Backbone.Wreqr.EventAggregator();

						listgenController = new Portal.ListGenerator.Controller();
						this.setupTabsView();
						
						WoundCareApplet.vent.on("show",function(){
							Portal.containerRegion.currentView.$el.attr('style', Portal.scrollableZoneHeight() );
						});

						if( timer )
						{
							clearInterval( timer );
						}
						timer = setInterval( function(){
							console.log("save");
							if (Portal.containerRegion.currentView)
								Portal.containerRegion.currentView.trigger("autosave");
						}, (WoundCareApplet.autoSaveIntervalinMinutes||1) * 60000 );
						
						this.ventis();
						that.setupNoteWriterEventActions();
						
						this.appletModel = new WoundCareApplet.AppletModel({
							name: 'woundcare',
							title: 'Skin Assessments',
							type: 'Applet',
							url: '#wound-care',
							display: true,
							focus: 'subject'
						});
						Portal.vent.trigger('add:applet', that.appletModel);
						that.setupActionsForWhenNewPatientLoads();
						that.loadResourceDirectory();
						WoundCareApplet.vent.on('load:failed', function () {
							console.log('failure to load resources');
						});
					},
					setupNoteWriterEventActions: function() {
						var HealthFactorsModel = Backbone.Model.extend();
						var healthFactorsSync = new HealthFactorsModel();
						WoundCareApplet.vent.on("write-to-note", function(){
							if (Portal.containerRegion.currentView)
								Portal.containerRegion.currentView.trigger("write-to-note");
						});
						that.listenTo( Portal.vent, "note-writer:close", function(e){
							WoundCareApplet.vent.trigger("note-writer-close" ,e);
						});
						that.listenTo(Portal.vent,  "note-writer:before:open" , function(e){ //note-writer-open
							WoundCareApplet.vent.trigger("note-writer-open" ,e);
							healthFactorsSync.fetch({async:false, url: WoundCareApplet.resources.get("skin-assessment-status").get("href")+"/WRITTEN_TO_NOTE"});
							//push text to nw
							Portal.commands.execute("note-writer:add:note", {} , {noteBody:that.generateNoteText(healthFactorsSync) , healthFactors: this.getHFObject(healthFactorsSync)});
							WoundCareApplet.vent.trigger("write-to-note");
						});
						that.listenTo(Portal.vent, 'note-writer:sign', function(){
							healthFactorsSync.fetch({async:false, url: WoundCareApplet.resources.get("skin-assessment-status").get("href")+"/SAVED"});
							that.fetchModels();
						});
					},
					setupActionsForWhenNewPatientLoads: function () {
						Portal.vent.on('load:patient', function () {
							venti = false;
							that.setupTabsView();
							that.ventis();
							console.log('patient loaded');
							that.loadResourceDirectory();

						});
					},
					setupTabsView: function() {
						tabsView =  new TabsView({
							model: new Backbone.Model({tabs:[]})
							,vent:WoundCareApplet.vent
						});
						var searchTab = {label:"Patient List" ,checked:"true",view:  function(){ return listgenController.getLayout("patient");} };
						tabsView.setTabNum(0, searchTab );
					},
					setTab:function(tabObject){

						tabsView.setTabNum(1,tabObject);
						Portal.containerRegion.show(tabsView);

					},
					getHFObject: function(hf) {
						var s = hf.attributes.skinInspection.healthFactors, 
						b = hf.attributes.bradenAssessment.healthFactors,
						e = hf.attributes.education.healthFactors;
						return _.union(s?s:[],b?b:[],e?e:[]);
					},
					fetchModels: function() {
						modelUrl = WoundCareApplet.resources.get('skin-assessment').get('href');
						WoundCareApplet.PreviousSkinCheckModel = new SkinCheckPastModel({url:WoundCareApplet.resources.get('past-skin-assessments').get('href')});
						WoundCareApplet.CurrentSkinCheckModel = new SkinCheckModel(modelUrl);
						WoundCareApplet.CurrentSkinCheckModel.fetch({data:JSON.stringify({admittedDateTime:Portal.patient().get('admittedDateTime')}),type:'POST', 'contentType':'application/json',
							success:function(){
//								console.log('success!');
								WoundCareApplet.CurrentSkinCheckModel.url = WoundCareApplet.CurrentSkinCheckModel.get('link')[0].href;
								venti = true;
								WoundCareApplet.vent.trigger(lastViewEvent);
								WoundCareApplet.vent.trigger('load:models');
							},
							fail: function() {
								venti = false;
							}
						});
						WoundCareApplet.PreviousSkinCheckModel.fetch();
					},
					generateNoteText: function(healthFactorsSync){
						if (!WoundCareApplet.CurrentSkinCheckModel) return "";
						var noteText="",
							skinStat      = WoundCareApplet.CurrentSkinCheckModel.get("skinInspection").status ,
							bradenStat    = WoundCareApplet.CurrentSkinCheckModel.get("bradenAssessment").status ,
							educationStat = WoundCareApplet.CurrentSkinCheckModel.get("education").status ,
							riskStat      = WoundCareApplet.CurrentSkinCheckModel.get("riskFactorAssessment").status ;
						if((skinStat !== "ACTIVE" && bradenStat !== "ACTIVE") ||
								riskStat !=='ACTIVE' || educationStat !=='ACTIVE') {
							noteText += "\n---------------------------------------------\n";
							noteText += "The data below is from the Skin Check app.\n";
							noteText += "---------------------------------------------\n";
							noteText += "\n";
						}
						if (skinStat !== "ACTIVE" && bradenStat !== "ACTIVE"){
							//skin assessment
							noteText += "\nSkin Assessment\n";
							noteText += "---------------\n";
							noteText += this.generateSkinAssessment();
							noteText += this.generateHealthFactors(healthFactorsSync.attributes.skinInspection.healthFactors);
							//braden Scale
							noteText += "\nBraden Scale\n";
							noteText += "------------\n";
							noteText += this.generateBradenScale();
							
							noteText += this.generateHealthFactors(healthFactorsSync.attributes.bradenAssessment.healthFactors);
							WoundCareApplet.CurrentSkinCheckModel.get("skinInspection").status = "WRITTEN_TO_NOTE";
							WoundCareApplet.CurrentSkinCheckModel.get("bradenAssessment").status = "WRITTEN_TO_NOTE";
						}

						//additional risk factors
						if (riskStat !=='ACTIVE') {
							var risky = this.generateRiskFactors();
							WoundCareApplet.CurrentSkinCheckModel.get("riskFactorAssessment").status = "WRITTEN_TO_NOTE";
							noteText += "\nAdditional Risk Factors\n";
							noteText += "-----------------------\n";
							noteText += risky;
						}
						//Education
						if (educationStat !=='ACTIVE') {
							var edy = this.generateEducation();
							WoundCareApplet.CurrentSkinCheckModel.get("education").status = "WRITTEN_TO_NOTE";
							noteText += "\nEducation\n";
							noteText += "---------\n";
							noteText += edy;
							noteText += this.generateHealthFactors(healthFactorsSync.attributes.education.healthFactors);
						}
						
						return noteText;
					},
					generateHealthFactors: function(hf) {
						var t, r = '';
						t = _.map( hf, function( el ){
							return el.healthFactorDescription;
						} ).join( ', ') || '';
						if (t==='') return t;
						r += "Health Factors\n";
						r += "--------------\n";
						r += t + '\n';
						return r;
					},
					generateSkinAssessment:function(){
						var skinAssessment = WoundCareApplet.CurrentSkinCheckModel.get("skinInspection"),
							sText ="",
							skinQuestionHash = {
								allAreasAssessed: "All areas assessed",
								riskFactorSelections: "Major risk factors/special populations",
								skinPatches: "Skin patches",
								skinColor: "Skin color",
								skinTemperature: "Skin Temperature",
								skinMoisture: "Skin moisture",
								skinTurgor: "Skin turgor",
								skinProblems: "Skin problems",
								ulcerPresent: "Is a pressure ulcer or other wound present?"

							};
						_.each(skinQuestionHash, function( qlabel, key){
							sText += "\n"+ qlabel +":\n";
							if (skinAssessment[key] !== undefined) {
								if (key==='allAreasAssessed')
									sText += " value: "+ (skinAssessment[key]?'All Areas Assessed':'All Areas Not Assessed')+"\n";
								else
									sText += " value: "+ skinAssessment[key] +"\n";
								if (skinAssessment[key+'Comment'])
									sText += " comment: "+ skinAssessment[key+'Comment']+'\n';
							}
						});
						sText += "\n";
						return sText;
					},
					generateBradenScale:function(){
						var bradenScale = WoundCareApplet.CurrentSkinCheckModel.get("bradenAssessment"),
							bText ="",
							bradenHash = WoundCareApplet.CurrentSkinCheckModel.staticBraden().braden;
						_.each(bradenHash, function( val, key){
							var num = bradenScale[key];
							bText += "\n"+ val.name +":\n";
							if (num) {
								if (key==='frictionAndShear')
									bText += " "+ val.values[3-num].name +'\n';
								else
									bText += " "+ val.values[4-num].name +'\n';
							}
						});
						bText += '\n';
						return bText;
					},
					generateRiskFactors:function(){
						var riskFactors = WoundCareApplet.CurrentSkinCheckModel.get("riskFactorAssessment"),
							rfText ="",
							noStuff = true,
							riskQuestionHash = {
								alterationsInSensation: "Alterations in Sensation",
								alterationsInMobility: "Alterations in Mobility",
								frictionOrShear: "Friction or Shear",
								alterationInNutritionOrHydration: "Alterations in Nutrition or Hydration",
								moisture: "Moisture",
								otherDiagnoses:"Other Diagnoses",
								devicesAndEquipment: "Devices and Equipment"
							};
						_.each(riskQuestionHash, function( qlabel, key){
							if (riskFactors[key]){
								rfText += "\n"+ qlabel +":\n";
								_.each(riskFactors[key], function(ans){
									noStuff = false;
									rfText += " "+ ans.value+"\n";
								});
							}
						});
						rfText += "\n";
						if (noStuff)
							rfText = '';
						return rfText;
					},
					generateEducation:function(){
						var education = WoundCareApplet.CurrentSkinCheckModel.get("education"),
						eduText ="",
						noStuff = true,
						eduQuestionHash = {
							desireToLearn: "Evaluated desire to learn:",
							abilityToComprehend: "Evaluated ability to comprehend:",
							pressureUlcer: "Defined a pressure ulcer?",
							riskFactors: "Explained risk factors?",
							routineSkinInspection: "Explained a routine skin inspection?",
							importanceOfNutritionEtc: "Discussed the importance of nutrition, hydration, mobility, position changes, pressure redistribution, and relief?",
							treatmentPlan: "Explained the treatment plan?",
							preventativeSkinCare: "Explained preventative skin care?",
							ulcerManagement: "Explained ulcer management (if necessary)?",
							printedEducationMaterial: "Provided printed education material?",
							roleOfVeteran: "Discussed the role of the Veteran and/or caregivers including active participation in prevention and discharge planning?",
							responseToEducation: "Documented response to education:"


						};
						_.each(eduQuestionHash, function( qlabel, key){
							var p = education[key].patient.value,
								c = education[key].caregiver.value;
							if ((c && c!== '') || (p && p!=='')) {
								noStuff = false;
								if (key === 'treatmentPlan')
									educationToNote = true;
								eduText += "\n"+ qlabel +":\n";
								eduText += p?" patient response: "+ p +"\n":'';
								eduText += c?" caregiver response: "+ c +"\n":'';
							}

						});
						if (education.comment && education.comment !== ''){
							eduText += "\nComment:\n";
							eduText += ' '+education.comment+'\n';
						}
						eduText += "\n";
						if (noStuff)
							eduText = '';
						return eduText;
					},
					onClose: function (){
						clearInterval( timer );
					},
					main: function () {
						this.makeVent('run:main');
					},
					loadResourceDirectory: function () {
						WoundCareApplet.resources = new WoundCareApplet.Resources();
//						console.log(Portal.patient().get('patientIdentifier').assigningAuthority);
						if (!Portal.patient().get('patientIdentifier') || !Portal.patient().get('patientIdentifier').assigningAuthority) {
							//there is not patient in context, nothing to load right now
							return;
						}

						var deferred = $.Deferred(),
							location = window.location,
							prodPath = location.origin,
							devPath = location.protocol + '//' + location.hostname + ':8080', //Given services are running in tomcat
							path = prodPath,
							servicesPath = '/SkinCheckServiceWeb/rest/skin-check/resource-directory?assigningAuthority=' +
								Portal.patient().get('patientIdentifier').assigningAuthority + '&patientId=' + Portal.patient().get('patientIdentifier').uniqueId;
						if (location.hostname === 'localhost' && location.port !== '8080') {
							path = devPath;
						}
						path = path + servicesPath;
						WoundCareApplet.resources.fetch({url: path, async: false})
							.done(function (data) {

								WoundCareApplet.autoSaveIntervalinMinutes = data.autoSaveIntervalinMinutes || 1;
								that.fetchModels();
								WoundCareApplet.vent.trigger('load:resources');
							})
							.fail(function () {
								venti = false;
								WoundCareApplet.vent.trigger('load:failed');
							});
						return deferred.promise();
					},
					ventis: function () {
						WoundCareApplet.vent.on('run:listgen', function() {
							lastViewEvent='run:listgen';
							that.onAppletLoad();
							that.constructViews();

							listgenController.search('patients');
							Portal.containerRegion.show(listgenController.layout);
						});
						function loadMain(landing) {
							WoundCareApplet.CurrentSkinCheckModel.fetch({
								success: function (val) {
									if (typeof tabsView !== 'undefined' && tabsView.getClosed()) {
										that.setupTabsView();
									}
									that.onAppletLoad();
									that.constructViews();
									var appletView = new AppletView({model:val,vent:WoundCareApplet.vent });
									that.setTab({label:"Skin Assessments", view: appletView });
									if (!landing) {
										that.setTab({label:"Skin Assessments", view: appletView });
										tabsView.showTabNum(0);
									}
								}
							});
						}
						WoundCareApplet.vent.on('run:main', function() {
							lastViewEvent = 'run:main';
							loadMain(false);
						});
						WoundCareApplet.vent.on('run:landingPage', function() {
							lastViewEvent = 'run:landingPage';
							loadMain(true);
						});
						WoundCareApplet.vent.on('run:braden', function () {
							lastViewEvent='run:braden';
							WoundCareApplet.CurrentSkinCheckModel.fetch({
								success: function (val) {
									var stat = val.attributes.bradenAssessment ? val.attributes.bradenAssessment.status : "";
									that.onAppletLoad();
									that.constructViews();
									that.setTab({label:"Braden Scale Assessment", view:new BradenScaleView({model: val,vent:WoundCareApplet.vent})});
								}
							});
						});
						WoundCareApplet.vent.on('run:bradenReview', function (sum) {
							lastViewEvent='run:bradenReview';
							that.onAppletLoad();
							that.constructViews();
							var model = new Backbone.Model(_.extend({
								score: sum
							}, that.getScore(sum)));
							that.setTab({label:"Braden Scale Assessment", view:new BradenReviewView({model: model,vent:WoundCareApplet.vent})});
						});
						WoundCareApplet.vent.on('run:prevInspections', function () {
							lastViewEvent='run:prevInspections';
							WoundCareApplet.PreviousSkinCheckModel.fetch({
								success: function (val) {
									that.onAppletLoad();
									that.constructViews();
									that.setTab({label:"Previous Assessments", view:new PrevInspectionsView({model: val,vent:WoundCareApplet.vent})});
								}
							});
						});
						WoundCareApplet.vent.on('run:prevInspection', function (id) {
							lastViewEvent='run:prevInspection';
							WoundCareApplet.PreviousSkinCheckModel.fetch({

								success: function (val) {
									var result = $.grep(val.get('skinCheckAssessmentHistory'), function (e) {
										return e.id == id;
									})[0];
									var score = that.getScore(result.bradenAssessment.score);
									score.bradenAssessment = result.bradenAssessment;
									score.updateDate = result.updateDate;
									var model = new Backbone.Model(_.extend({}, score));
									that.onAppletLoad();
									that.constructViews();
									that.setTab({label:"Previous Assessments", view:new PrevInspectionView({model: model,vent:WoundCareApplet.vent})});
								}
							});
						});
						WoundCareApplet.vent.on('run:newSkinInspection', function () {
							lastViewEvent='run:newSkinInspection';
							WoundCareApplet.CurrentSkinCheckModel.fetch({
								success: function (val) {
//									console.log(val);
									that.onAppletLoad();
									that.constructViews();
									that.setTab({label:"Skin Assessment", view:new NewSkinInspectionView({model: val,vent:WoundCareApplet.vent})});
								}
							});

						});
						WoundCareApplet.vent.on('run:riskFactors', function () {
							lastViewEvent='run:riskFactors';
							WoundCareApplet.CurrentSkinCheckModel.fetch({
									success: function (val) {
//										console.log(val);
										that.onAppletLoad();
										that.constructViews();
										that.setTab({label:"Additional Risk Factors", view:new RiskFactorsView({model: val,vent:WoundCareApplet.vent})});
									}
							});
						});
						WoundCareApplet.vent.on('run:riskFactorsSaved', function () {
							lastViewEvent='run:riskFactorsSaved';
							WoundCareApplet.CurrentSkinCheckModel.fetch({
								success: function (val) {
									val.get('riskFactorAssessment').saved = true;
//									console.log(val);
									that.onAppletLoad();
									that.constructViews();
									that.setTab({label:"Additional Risk Factors", view:new RiskFactorsView({model: val,vent:WoundCareApplet.vent})});
								}
							});
						});
						WoundCareApplet.vent.on('run:education', function () {
							lastViewEvent='run:education';
							WoundCareApplet.CurrentSkinCheckModel.fetch({
									success: function (val) {
										that.onAppletLoad();
										that.constructViews();
										that.setTab({label:"Educate", view:new EducationView({model:val,vent:WoundCareApplet.vent})});
									},
									error: function() {
										console.log('error');
									},
									failure: function() {
										console.log('failure');
									}
								});
						});
					},
					makeVent: function(trigger, param) {
						if (venti) {
							WoundCareApplet.vent.trigger(trigger, param);
						}
						else {
							WoundCareApplet.vent.once('load:models', function () {
								WoundCareApplet.vent.trigger(trigger,param);
							});
						}
					},
					landingPage: function() {
						this.makeVent('run:landingPage');
					},
					listgen: function() {
						this.makeVent('run:listgen');
					},
					education: function() {
						this.makeVent('run:education');
					},
					braden: function () {
						this.makeVent('run:braden');
					},
					bradenReview: function (sum) {
						this.makeVent('run:bradenReview', sum);
						history = 'braden-scale';
					},
					prevInspections: function () {
						this.makeVent('run:prevInspections');
						history = Backbone.history.fragment;
					},
					prevInspection: function (id) {
						this.makeVent('run:prevInspection', id);
						history = 'prev-inspections';
					},
					newSkinInspection: function () {
						this.makeVent('run:newSkinInspection');
						history = Backbone.history.fragment;
					},
					riskFactors: function (past) {
						history = Backbone.history.fragment;
						if (past === 'saved')
							this.makeVent('run:riskFactorsSaved');
						else
							this.makeVent('run:riskFactors');
					},
					onAppletLoad: function () {
						Portal.vent.trigger('load:css', Portal.baseUrl + 'applets/wound-care-applet/_assets/css/applet.css');
					},
					constructViews: function () {
						Portal.vent.trigger('load:applet', this.appletModel);
					},
					getScore: function (sum) {
						var score = {};
						score.recommendations = [
							'<p class="wc-dt wc-title"><button data-role="none" class="wc-trans-btn wc-arrow-r">Manage Moisture:</button></p><ul data-role="listview" class="wc-dd wc-hidden"><li data-icon="false" data-role="none" class="wc-review-li">Use commercial moisture barrier</li><li data-icon="false" data-role="none" class="wc-review-li">Use absorbant pads or diapers that wick & hold moisture</li><li data-icon="false" data-role="none" class="wc-review-li">Address cause if possible</li><li data-icon="false" data-role="none" class="wc-review-li">Offer bedpan/urinal and glass of water in conjunction with turning schedules</li></ul>',
							'<p class="wc-dt wc-title"><button data-role="none" class="wc-trans-btn wc-arrow-r">Manage Nutrition:</button></p><ul data-role="listview" class="wc-dd wc-hidden"><li data-icon="false" data-role="none" class="wc-review-li">Increase protein intake</li><li data-icon="false" data-role="none" class="wc-review-li">Increase calorie intake to spare proteins</li><li data-icon="false" data-role="none" class="wc-review-li">Supplement with multi-vitamin (should have Vitamin A, C & E)</li><li data-icon="false" data-role="none" class="wc-review-li">Act quickly to alleviate deficits</li><li data-icon="false" data-role="none" class="wc-review-li">Consult dietitian</li></ul>',
							'<p class="wc-dt wc-title"><button data-role="none" class="wc-trans-btn wc-arrow-r">Manage Friction & Shear:</button></p><ul data-role="listview" class="wc-dd wc-hidden"><li data-icon="false" data-role="none" class="wc-review-li">Elevate HOB no more than 30!</li><li data-icon="false" data-role="none" class="wc-review-li">Use trapeze when indicated</li><li data-icon="false" data-role="none" class="wc-review-li">Use lift sheet to move patient</li><li data-icon="false" data-role="none" class="wc-review-li">Protect elbows & heels if being exposed to friction</li></ul>',
							'<p class="wc-dt wc-title"><button data-role="none" class="wc-trans-btn wc-arrow-r">Other general care issues:</button></p><ul data-role="listview" class="wc-dd wc-hidden"><li data-icon="false" data-role="none" class="wc-review-li">No massage of reddened bony prominences</li><li data-icon="false" data-role="none" class="wc-review-li">No donut type devices</li><li data-icon="false" data-role="none" class="wc-review-li">Maintain good hydration</li><li data-icon="false" data-role="none" class="wc-review-li">Avoid drying the skin</li></ul>'
						];
						if (sum >= 19) {
							score.status = "NOT AT RISK";
							score.considerations = [];
							score.recommendations = [];
							return score;
						}
						if (sum >= 15) {
							score.status = "AT RISK";
							score.considerations = [
								'Frequent Turning',
								'Maximal Remobilization',
								'Protect Heels',
								'Manage moisture, nutrition, friction & shear (see below for details)',
								'Pressure-reduction support surface if bed- or chair-bound',
								'* If other major risk factors are present (advanced age, fever, poor dietary intake of protein, diastolic pressure below 60, hemodynamic instability) advance to next level of risk'
							];
							return score;
						}
						if (sum >= 13) {
							score.status = "MODERATE RISK";
							score.considerations = [
								'Turning Schedule',
								'Use pillows/foam wedges for 30!',
								'Lateral Positioning',
								'Pressure-reduction support surface',
								'Maximal Remobilization',
								'Protect Heels',
								'Manage moisture, nutrition, friction & shear (see below for details)',
								'* If other major risk factors present, advance to next level of risk'
							];
							return score;
						}

						if (sum >= 10) {
							score.status = "HIGH RISK";
							score.considerations = [
								'Increase frequency of turning',
								'Supplement with small shifts',
								'Pressure reduction support surface',
								'Use pillows/foam wedges for 30!',
								'Lateral Positioning',
								'Maximal Remobilization',
								'Protect Heels',
								'Manage moisture, nutrition, friction & shear (see below for details)'
							];
							return score;
						}

						score.status = "VERY HIGH RISK";
						score.considerations = [
							'Increase frequency of turning',
							'Supplement with small shifts',
							'Pressure reduction support surface',
							'Use pillows/foam wedges for 30!',
							'Lateral Positioning',
							'Maximal Remobilization',
							'Protect Heels',
							'Manage moisture, nutrition, friction & shear (see below for details)',
							'Use pressure-relieving surface if patient has intractable pain or severe pain exacerbated by turning over or additional risk factors',
							'* Low air loss beds do not substitute for turning schedules'
						];
						return score;
					}
				});
//			});
	});